// XISLVarList.cpp: CXISLVarList NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLVarList.h"
#include "XISLVar.h"
#include "XISLTag.h"
#include "XISLRootTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CXISLRootTag *g_pAppRootTag;
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLVarList::CXISLVarList(CXISLTag *pParent)
{
	m_pParent = pParent;
	switch(pParent->m_nTagType)
	{
	case ID_TAG_XISL:
		m_nVarScope = ID_VARSCOPE_DOCUMENT;
		break;
	case ID_TAG_DIALOG:
		m_nVarScope = ID_VARSCOPE_DIALOG;
		break;
	case ID_TAG_EXCHANGE:
		m_nVarScope = ID_VARSCOPE_EXCHANGE;
		break;
	case ID_TAG_BEGIN:
	case ID_TAG_END:
		m_nVarScope = ID_VARSCOPE_LOCAL;
		break;
	default:
		ASSERT(NULL);
	}
}

CXISLVarList::~CXISLVarList()
{
	POSITION pos = m_VarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_VarList.GetNext(pos);
		delete pVar;
	}
	m_pParent = NULL;
}

CXISLVarList::CXISLVarList(const CXISLVarList &cpXISL)
{
	m_nVarScope = cpXISL.m_nVarScope;
	POSITION pos = cpXISL.m_VarList.GetHeadPosition();
	while(pos)
		m_VarList.AddTail(cpXISL.m_VarList.GetNext(pos));
}

CXISLVarList& CXISLVarList::operator=(const CXISLVarList &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nVarScope = cpXISL.m_nVarScope;
		POSITION pos = cpXISL.m_VarList.GetHeadPosition();
		while(pos)
			m_VarList.AddTail(cpXISL.m_VarList.GetNext(pos));
	}
	return *this;
}

//̕ϐXgAvP[Vϐɂ
void CXISLVarList::SetAppVar()
{
	//AvP[Vϐɂł̂̓hLgێĂϐXĝ
	if(m_pParent->m_nTagType != ID_TAG_XISL)
		ASSERT(NULL);

	m_nVarScope = ID_VARSCOPE_APPLICATION;
}

//XISLԂ
void CXISLVarList::GetXISLString(CString &strXISL)
{
	if(m_VarList.IsEmpty())
		return;

	strXISL = "<";
	strXISL += XISL_VARSCOPE[m_nVarScope];
	strXISL += ">\r\n";

	BOOL bCount = FALSE;
	POSITION pos = m_VarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_VarList.GetNext(pos);
		if(pVar->m_bDeclare)
		{
			strXISL += "<var name=\"";
			strXISL += pVar->m_strName;
			if(!pVar->m_strExpr.IsEmpty())
			{
				strXISL += "\" expr=\"";
				strXISL += pVar->m_strExpr;
			}
			strXISL += "\"/>\r\n";
			bCount = TRUE;
		}
	}

	if(!bCount)
	{
		strXISL = "";
		return;
	}

	strXISL += "</";
	strXISL += XISL_VARSCOPE[m_nVarScope];
	strXISL += ">\r\n";
}

//ϐ̓o^
//F0 sF-1
int CXISLVarList::RegistVar(CXISLVar *pVar)
{
	POSITION pos = m_VarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pRegistedVar = (CXISLVar*)m_VarList.GetNext(pos);
		if(pRegistedVar->m_strName.Compare(pVar->m_strName) == 0)
		{
			CString strMsg;
			strMsg.Format("ϐ %s ͂łɐ錾Ă܂",pVar->m_strName);
			AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return -1;
		}
	}

	pVar->m_pParent = this;
	m_VarList.AddTail(pVar);
	pVar->m_nReferCount = 1;
	return 0;
}

//o^Ăϐ폜
//F0@̕ϐQƂĂ܂݂F-1
//̕ϐ̓Xgɑ݂ȂF-2
int CXISLVarList::RemoveVar(CXISLVar *pVar)
{
	if(pVar->m_nReferCount != 1)
	{
		AfxMessageBox("̕ϐ͕ʂ̌ŎgpĂ̂ō폜ł܂",
						MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return -1;		
	}

	POSITION pos = m_VarList.Find(pVar);
	if(pos)
	{
		m_VarList.RemoveAt(pos);
		return 0;
	}

	return -2;
}


//ϐ̎QƉ񐔂𑝌
//BOOL bAdd :TRUEF ₷CFALSEF 炷
//F0@̕ϐ̓Xgɑ݂Ȃ:-1
int CXISLVarList::ReferVar(LPCTSTR lpszVarName,BOOL bAdd)
{
	POSITION pos = m_VarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pRegistedVar = (CXISLVar*)m_VarList.GetNext(pos);
		if(pRegistedVar->m_strName.Compare(lpszVarName) == 0)
		{
			if(bAdd)
				pRegistedVar->m_nReferCount++;
			else 
			{
				if(pRegistedVar->m_nReferCount > 1)
					pRegistedVar->m_nReferCount--;
				else
					ASSERT(NULL);
			}
			return 0;
		}
	}

	return -1;
}

int CXISLVarList::GetVarNameList(CString &strList)
{
	int nCount = m_VarList.GetCount();

	POSITION pos = m_VarList.GetHeadPosition();
	while(pos != NULL)
	{
		CXISLVar *pVar = (CXISLVar*)m_VarList.GetNext(pos);
		strList += pVar->GetVarName();
		strList += ",";
	}

	strList.Delete(strList.GetLength()-1);
	return nCount;
}

//w肵XgRg[ɕϐXgǉ
int CXISLVarList::SetVar2ListBox(CListCtrl &lbCtrl,int nCount)
{
	LVITEMA item;

	CString strTemp;
	POSITION pos = m_VarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_VarList.GetNext(pos);

		item.mask = LVIF_TEXT|LVIF_PARAM;
		item.iItem = nCount;
		item.iSubItem = 0;
		item.lParam = (LPARAM)pVar;
		item.pszText = XISL_VARSCOPE2[m_nVarScope];
		lbCtrl.InsertItem(&item);

		item.mask = LVIF_TEXT;
		item.iSubItem = 1;
		strTemp = pVar->GetVarName();
		item.pszText = strTemp.GetBuffer(2);
		lbCtrl.SetItem(&item);

		nCount++;
	}
	return nCount;
}

CXISLVar* CXISLVarList::FindVar(LPCTSTR lpszVarName)
{
	POSITION pos = m_VarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_VarList.GetNext(pos);
		if(pVar->m_strName.Compare(lpszVarName) == 0)
			return pVar;
	}
	return NULL;
}

//ẽXR[v܂ł̂ڂĕϐ
CXISLVar* CXISLVarList::FindVarWithParent(LPCTSTR lpszVarName)
{
	CXISLVar *pVar=NULL;

	CString strScope;
	CString strName = lpszVarName;
	int nDot = strName.Find(".");
	if(nDot != -1)
	{
		strScope = strName.Left(nDot);
		strName.Delete(0,nDot+1);

		return FindScopeVar(strScope,strName);
	}
	else
	{
		POSITION pos = m_VarList.GetHeadPosition();
		while(pos)
		{
			pVar = (CXISLVar*)m_VarList.GetNext(pos);
			if(pVar->m_strName.Compare(strName) == 0)
				return pVar;
		}

		if(m_pParent->m_nTagType == ID_TAG_XISL)
		{
			if(g_pAppRootTag)
				pVar =  g_pAppRootTag->m_pDocumentVar->FindVar(strName);
		}
		else if(m_pParent->m_nTagType == ID_TAG_DIALOG)
		{
			CXISLRootTag *pRTag = (CXISLRootTag*)m_pParent->GetRootTag();
			pVar = pRTag->m_pDocumentVar->FindVarWithParent(lpszVarName);
		}
		else if(m_pParent->m_nTagType == ID_TAG_EXCHANGE
			|| m_pParent->m_nTagType == ID_TAG_BEGIN
			|| m_pParent->m_nTagType == ID_TAG_END)
		{
			CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pParent->GetParentDialogTag();
			pVar = pDTag->m_pDialogVar->FindVarWithParent(lpszVarName);
		}
	}

	return pVar;
}

CXISLVar* CXISLVarList::FindScopeVar(LPCTSTR lpszScope,LPCTSTR lpszVarName)
{
	CXISLVar *pVar=NULL;
	CString strScope = lpszScope;
	strScope.Remove(' ');
	if(strScope.Compare(XISL_VARSCOPE2[ID_VARSCOPE_APPLICATION]) == 0)
	{
		if(g_pAppRootTag)
			pVar = g_pAppRootTag->m_pDocumentVar->FindVar(lpszVarName);
	}
	else if(strScope.Compare(XISL_VARSCOPE2[ID_VARSCOPE_DOCUMENT]) == 0)
	{
		CXISLRootTag *pRTag = (CXISLRootTag*)m_pParent->GetRootTag();
		pVar = pRTag->m_pDocumentVar->FindVar(lpszVarName);
	}
	else if(strScope.Compare(XISL_VARSCOPE2[ID_VARSCOPE_DIALOG]) == 0)
	{
		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pParent->GetParentDialogTag();
		pVar = pDTag->m_pDialogVar->FindVar(lpszVarName);
	}
	else if(strScope.Compare(XISL_VARSCOPE2[ID_VARSCOPE_LOCAL]) == 0)
		pVar = FindVar(lpszVarName);
	else
	{
		CString strMsg;
		strMsg.Format("XR[v̎w肪sły%sz",lpszVarName);
		AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return NULL;
	}

	if(pVar == NULL)
	{
		CString strMsg;
		strMsg.Format("%s  %s ͐錾Ă܂",strScope,lpszVarName);
		AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
	}
	return pVar;
}
